% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/corr_matrix.R
\name{corr.matrix}
\alias{corr.matrix}
\title{Calculate correlation matrix and threshold}
\usage{
corr.matrix(dat, thresh = NULL, density = 0.1, exclusions = NULL, ...)
}
\arguments{
\item{dat}{Matrix or data frame of the columns to correlate}

\item{thresh}{Absolute correlation value to threshold by}

\item{density}{Keeps the top \emph{X}\% of correlations}

\item{exclusions}{Vector of indices (columns) to exclude (optional)}

\item{...}{Other arguments to be passed to \code{\link[Hmisc]{rcorr}}}
}
\value{
A list with the following components:
\item{R}{Correlation coefficients (default: Pearson).}
\item{P}{Associated p-values.}
\item{r.thresh}{Binary matrix indicating correlations that are above a
certain threshold.}
\item{threshold}{The threshold used.}
}
\description{
This function does a column-by-column correlation of a given data frame, and
will threshold the matrix based on a given density; e.g. 0.1 if you want to
keep only the 10\% strongest correlations.
}
\details{
If you wish to exclude regions from your analysis, you can give the indices
of their columns. Also returns the p-values. Essentially a wrapper for
\code{\link[Hmisc]{rcorr}}, with some added functionality to work with this
type of data more easily. By default, the Pearson correlation coefficients
are calculated, but can return Spearman by passing an additional argument.
}
\seealso{
\code{\link[Hmisc]{rcorr}}
}

