% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rich_club_norm.R
\name{rich.club.norm}
\alias{rich.club.norm}
\title{Calculate the normalized rich club coefficient}
\usage{
rich.club.norm(g, N = 100, rand = NULL, ...)
}
\arguments{
\item{g}{The igraph graph object of interest}

\item{N}{The number of random graphs to generate (default: 100)}

\item{rand}{A list of igraph graph objects, if random graphs have already
been generated (default: NULL)}

\item{...}{Other parameters (passed to \emph{rich.club.coeff})}
}
\value{
A list with two elements:
\item{phi.rand}{A matrix with \emph{N} rows and \emph{max(degree(g))}
columns, where each row contains the coefficients for a given random graph.}
\item{phi.orig}{A vector of the rich-club coefficients for the original
graph.}
\item{phi.norm}{A named vector of the normalized rich club coefficients.}
\item{p}{The p-value based on the \emph{N} random graphs generated.}
}
\description{
This function will generate a number of random graphs, calculate their rich
club coefficients (\eqn{\phi}), and return \eqn{\phi} of the graph of
interest divided by the mean across random graphs, i.e. \eqn{\phi_{norm}}.
If random graphs have already been generated, you can supply a list as an
argument (since graph generation is time consuming).
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Colizza V., Flammini A., Serrano M.A., Vespignani A. (2006)
\emph{Detecting rich-club ordering in complex networks}. Nature Physics,
2:110-115.
}
\seealso{
\code{\link{rich.club.coeff}, \link{sim.rand.graph.par}}
}

