% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/set_brainGraph_attributes.R
\name{set.brainGraph.attributes}
\alias{set.brainGraph.attributes}
\title{Set a number of graph and vertex attributes useful in MRI analyses}
\usage{
set.brainGraph.attributes(g, atlas = NULL, modality = NULL,
  subject = NULL, group = NULL, rand = FALSE)
}
\arguments{
\item{g}{An igraph object}

\item{atlas}{A character vector indicating which atlas was used for the nodes}

\item{modality}{A character vector indicating imaging modality (e.g. 'dti')}

\item{subject}{A character vector indicating subject ID (default: NULL)}

\item{group}{A character vector indicating group membership (default: NULL)}

\item{rand}{Logical indicating if the graph is random or not (default: FALSE)}
}
\value{
g A copy of the same graph, with the following attributes:
\item{Graph-level}{Package version, atlas, density, connected component sizes,
diameter, \# of triangles, transitivity, average path length, assortativity,
clique number, global & local efficiency, modularity, vulnerability, hub score,
rich-club coefficient, \# of hubs, edge asymmetry, and modality}
\item{Vertex-level}{Degree, strength, betweenness/eigenvector and leverage
centralities, hubs, transitivity (local), coreness, local & nodal efficiency,
color (community), color (lobe), color (component), membership (community),
membership (component), participation coefficient, within-module degree
z-score, vulnerability, and coordinates (x, y, and z)}
\item{Edge-level}{Color (community), color (lobe), color (component), edge
betweenness, Euclidean distance (in mm)}
}
\description{
This function will set a number of graph, vertex, and edge attributes of a
given igraph object.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\seealso{
\code{\link[igraph]{components}, \link[igraph]{diameter},
\link[igraph]{clique_num}, \link[igraph]{centr_betw}, \link{part.coeff},
\link[igraph]{edge.betweenness}, \link[igraph]{centr_eigen},
\link[igraph]{hub.score},
\link[igraph]{authority.score}, \link[igraph]{transitivity},
\link[igraph]{mean_distance}, \link[igraph]{assortativity.degree},
\link[igraph]{cluster_louvain}, \link{graph.efficiency}, \link{color.edges},
\link{rich.club.coeff}, \link{within_module_deg_z_score},
\link[igraph]{coreness}, \link{spatial.dist}, \link{vulnerability},
\link{centr_lev}, \link{edge_asymmetry}, \link[igraph]{graph.knn}}
}

