% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_brainGraph_gui.R
\name{update_brainGraph_gui}
\alias{update_brainGraph_gui}
\title{Function to dynamically plot a graph}
\usage{
update_brainGraph_gui(plotDev, graph1, graph2, plotFunc, vertSize, edgeWidth,
  vertColor, hemi, lobe, orient, vertSize.min, edgeWidth.min,
  vertSize.const = NULL, edgeWidth.const = NULL, vertLabels = NULL,
  comm = NULL, kNumComms = NULL, neighb = NULL, neighbMult = NULL,
  slider = NULL, vertSize.other = NULL, vertSize.eqn = NULL,
  showDiameter = NULL, edgeDiffs = NULL)
}
\arguments{
\item{plotDev}{A Cairo device for the plotting area}

\item{graph1}{An igraph graph object for the first plotting area}

\item{graph2}{An igraph graph object for the  second plotting area}

\item{plotFunc}{A function specifying which type of plot to use}

\item{vertSize}{A GTK combo box for scaling vertex size}

\item{edgeWidth}{A GTK entry for changing edge width}

\item{vertColor}{A GTK combo box for changing vertex colors}

\item{hemi}{A GTK combo box for plotting individual hemispheres}

\item{lobe}{A GTK combo box for plotting individual lobes}

\item{orient}{A GTK combo box for plotting a specific orientation}

\item{vertSize.min}{A GTK spin button for minimum vertex size}

\item{edgeWidth.min}{A GTK spin button for minimum edge width}

\item{vertSize.const}{A GTK entry for constant vertex size}

\item{edgeWidth.const}{A GTK entry for constant width}

\item{vertLabels}{A GTK check button for showing vertex labels}

\item{comm}{A GTK combo box for plotting individual communities}

\item{kNumComms}{Integer indicating the number of total communities (optional)}

\item{neighb}{A GTK combo box for plotting individual neighborhoods}

\item{neighbMult}{A GTK entry for joint neighborhoods of multiple vertices}

\item{slider}{A GTK horizontal slider widget for changing edge curvature}

\item{vertSize.other}{A GTK entry for vertex size (other attributes)}

\item{vertSize.eqn}{A GTK entry for equations to exclude vertices}

\item{showDiameter}{A GTK check button for showing the graph's diameter}

\item{edgeDiffs}{A GTK check button for showing edge diffs between graphs}
}
\description{
This function is called by \link{plot_brainGraph_gui} to update a plot
on-the-fly. It updates by calling the helper function \code{make.plot}.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}

