% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_neighborhood_multiple.R
\name{graph_neighborhood_multiple}
\alias{graph_neighborhood_multiple}
\title{Take the union of multiple neighborhood graphs}
\usage{
graph_neighborhood_multiple(g, vs)
}
\arguments{
\item{g}{The igraph graph object}

\item{vs}{Either a character or integer vector (vertex names or indices,
respectively) for the vertices of interest}
}
\value{
An igraph graph object containing the union of all edges and vertices
in the neighborhoods of the input vertices; only the vertex attribute
\emph{name} will be present
}
\description{
This function takes multiple vertices, creates graphs of their neighborhoods
(of order 1), and takes the union of those graphs.
}
\examples{
\dontrun{
subg <- graph_neighborhood_multiple(g1[[N]], c(24, 58))
subg <- graph_neighborhood_multiple(g1[[N]], c('lPCUN', 'rPCUN'))
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\seealso{
\code{\link[igraph]{make_ego_graph}}
}

