% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brainGraph.R
\name{plot_brainGraph}
\alias{plot_brainGraph}
\title{Plot a brain graph with a specific spatial layout}
\usage{
plot_brainGraph(g, plane = c("axial", "sagittal", "circular"),
  hemi = c("both", "L", "R"), subgraph = NULL, show.legend = FALSE,
  rescale = FALSE, asp = 0, main = NULL, sub = "default", ...)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{plane}{A character string indicating which orientation to plot
(default: 'axial')}

\item{hemi}{A character string indicating which hemisphere to plot (default:
'both')}

\item{subgraph}{A character string specifying an equation for deleting
vertices (default: NULL)}

\item{show.legend}{Logical indicating whether or not to show a legend
(default: FALSE)}

\item{rescale}{A logical, whether to rescale the coordinates (default: FALSE)}

\item{asp}{A numeric constant for the aspect ratio (default: 0)}

\item{main}{Character string for the main title (default: NULL)}

\item{sub}{Character string for the subtitle (default: 'default')}

\item{...}{Other parameters (passed to \code{\link{plot}}).}
}
\description{
This function plots a graph when the spatial layout of the nodes is important
(e.g. in the brain). The function \code{\link{set.brainGraph.attributes}}
needs to be run on the graph, and a valid set of coordinates provided for the
vertices. Most of the parameters valid here can be seen in
\code{\link{igraph.plotting}}.
}
\details{
With the argument \code{subgraph}, you can specify a simple logical equation
for which vertices to show. For example, \emph{'degree > 10'} will plot only
vertices with a \emph{degree} greater than 10. Combinations of \emph{AND}
(i.e., \code{&}) and \emph{OR} (i.e., \code{|}) are allowed.

To remove the subtitle at the bottom, simply specify \code{sub=NULL}.
}
\examples{
\dontrun{
plot_brainGraph(g[[1]], hemi='R')
plot_brainGraph(g[[1]], subgraph='degree > 10 | btwn.cent > 50')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}

