% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brainGraph_list.R
\name{plot_brainGraph_list}
\alias{plot_brainGraph_list}
\title{Write PNG files for a list of graphs}
\usage{
plot_brainGraph_list(g.list, fname.base, diffs = FALSE, ...)
}
\arguments{
\item{g.list}{A list of \code{igraph} graph objects}

\item{fname.base}{A character string specifying the base of the filename for
\emph{png} output}

\item{diffs}{A logical, indicating whether or not to highlight edge
differences (default: \code{FALSE})}

\item{...}{Other parameters (passed to \code{\link{plot_brainGraph}})}
}
\description{
This function takes a list of \code{igraph} graph objects and plots them over
an axial slice of the brain. A \code{png} file is written for each element of
the list, which can be joined as a \code{gif} or converted to video using a
tool outside of \code{R}.
}
\details{
You can choose to highlight edge differences between subsequent list
elements; in this case, new/different edges are colored pink.

This function may be particularly useful if the graph list contains graphs of
a single subject group at incremental densities, or if the graph list
contains graphs of each subject in a group.
}
\seealso{
Other Plotting functions: \code{\link{plot_brainGraph_gui}},
  \code{\link{plot_brainGraph}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
