% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rich_club.R
\name{rich_club_coeff}
\alias{rich_club_coeff}
\title{Calculate the rich club of a graph}
\usage{
rich_club_coeff(g, k = 1, weighted = FALSE)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{k}{Integer; the minimum degree for including a vertex (default: 1)}

\item{weighted}{Logical indicating whether or not edge weights should be
used (default: \code{FALSE})}
}
\value{
A list with the following components:
\item{phi}{The rich club coefficient, \eqn{\phi}.}
\item{graph}{A subgraph containing only the rich club nodes.}
\item{Nk}{The number of vertices in the rich club graph.}
\item{Ek}{The number of edges in the rich club graph.}
}
\description{
This function calculates the \emph{rich club} of a graph, both the
coefficient \eqn{\phi} and the nodes that make up this subgraph.
}
\references{
Zhou S., Mondragon R.J. (2004) \emph{The rich-club phenomenon
in the internet topology}. IEEE Comm Lett, 8:180-182.

Opsahl T., Colizza V., Panzarasa P., Ramasco J.J. (2008)
\emph{Prominence and control: the weighted rich-club effect}. Physical Review
Letters, 101.16:168702.
}
\seealso{
Other Rich-club functions: \code{\link{plot_rich_norm}},
  \code{\link{rich_club_attrs}},
  \code{\link{rich_club_norm}}, \code{\link{rich_core}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
