% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnrow.R
\name{bnrow}
\alias{bnrow}
\title{Count the number of rows of a big file without loading it in memory}
\usage{
bnrow(file = NULL)
}
\arguments{
\item{file}{String. Name or full path to a file compatible with data.table::fread()}
}
\value{
A numeric
}
\description{
Counts the number of rows using data.table::fread() and the "wc" Unix command.
This allows analyzing big files that would not fit in memory (and cause an error
such as "cannot allocate vector of size").
}
\examples{
file <- system.file("extdata", "test.csv", package = "bread")
## Counting rows (almost like the band)
bnrow(file = file)
}
