% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/richness_wlrm_ut.R
\name{wlrm_untransformed}
\alias{wlrm_untransformed}
\title{The untransformed weighted linear regression estimator for species richness estimation}
\usage{
wlrm_untransformed(
  input_data,
  cutoff = NA,
  print = NULL,
  plot = NULL,
  answers = NULL
)
}
\arguments{
\item{input_data}{An input type that can be processed by \code{convert()} or a \code{phyloseq} object}

\item{cutoff}{Maximum frequency count to use}

\item{print}{Deprecated; only for backwards compatibility}

\item{plot}{Deprecated; only for backwards compatibility}

\item{answers}{Deprecated; only for backwards compatibility}
}
\value{
An object of class \code{alpha_estimate}, or \code{alpha_estimates} for \code{phyloseq} objects
}
\description{
This function implements the untransformed version of the species richness
estimation procedure outlined in Rocchetti, Bunge and Bohning (2011).
}
\note{
This estimator is based on the negative binomial model and for that
reason generally produces poor fits to microbial data. The result is usually
artificially low standard errors. Caution is advised.
}
\examples{

wlrm_untransformed(apples)

}
\references{
Rocchetti, I., Bunge, J. and Bohning, D. (2011). Population size
estimation based upon ratios of recapture probabilities. \emph{Annals of
Applied Statistics}, \bold{5}.
}
\seealso{
\code{\link{breakaway}}; \code{\link{apples}};
\code{\link{wlrm_transformed}}
}
\author{
Amy Willis
}
\keyword{diversity}
\keyword{models}
