% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{azure_attributes}
\alias{azure_attributes}
\title{Azure Attributes}
\usage{
azure_attributes(
  first_on_demand = 1,
  availability = c("SPOT_WITH_FALLBACK", "SPOT", "ON_DEMAND"),
  spot_bid_max_price = -1
)
}
\arguments{
\item{first_on_demand}{Number of nodes of the cluster that will be placed on
on-demand instances. If this value is greater than 0, the cluster driver node
will be placed on an on-demand instance. If this value is greater than or
equal to the current cluster size, all nodes will be placed on on-demand
instances. If this value is less than the current cluster size,
\code{first_on_demand} nodes will be placed on on-demand instances and the
remainder will be placed on availability instances. This value does not
affect cluster size and cannot be mutated over the lifetime of a cluster.}

\item{availability}{One of \code{SPOT_WITH_FALLBACK}, \code{SPOT}, \code{ON_DEMAND.} Type
used for all subsequent nodes past the \code{first_on_demand} ones. If
\code{first_on_demand} is zero, this availability type will be used for the entire
cluster.}

\item{spot_bid_max_price}{The max bid price used for Azure spot instances.
You can set this to greater than or equal to the current spot price. You can
also set this to -1 (the default), which specifies that the instance cannot
be evicted on the basis of price. The price for the instance will be the
current price for spot instances or the price for a standard instance. You
can view historical pricing and eviction rates in the Azure portal.}
}
\description{
Azure Attributes
}
\seealso{
\code{\link[=db_cluster_create]{db_cluster_create()}}, \code{\link[=db_cluster_edit]{db_cluster_edit()}}

Other Cloud Attributes: 
\code{\link{aws_attributes}()},
\code{\link{gcp_attributes}()}
}
\concept{Cloud Attributes}
