% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{direct_access_index_spec}
\alias{direct_access_index_spec}
\title{Delta Sync Vector Search Index Specification}
\usage{
direct_access_index_spec(
  embedding_source_columns = NULL,
  embedding_vector_columns = NULL,
  schema
)
}
\arguments{
\item{embedding_source_columns}{The columns that contain the embedding
source, must be one or list of \code{\link[=embedding_source_column]{embedding_source_column()}}}

\item{embedding_vector_columns}{The columns that contain the embedding, must
be one or list of \code{\link[=embedding_vector_column]{embedding_vector_column()}}
vectors.}

\item{schema}{Named list, names are column names, values are types. See
details.}
}
\description{
Delta Sync Vector Search Index Specification
}
\details{
The supported types are:
\itemize{
\item \code{"integer"}
\item \code{"long"}
\item \code{"float"}
\item \code{"double"}
\item \code{"boolean"}
\item \code{"string"}
\item \code{"date"}
\item \code{"timestamp"}
\item \code{"array<float>"}: supported for vector columns
\item \code{"array<double>"}: supported for vector columns
}
}
\seealso{
\code{\link[=db_vs_indexes_create]{db_vs_indexes_create()}}

Other Vector Search API: 
\code{\link{db_vs_endpoints_create}()},
\code{\link{db_vs_endpoints_delete}()},
\code{\link{db_vs_endpoints_get}()},
\code{\link{db_vs_endpoints_list}()},
\code{\link{db_vs_indexes_create}()},
\code{\link{db_vs_indexes_delete}()},
\code{\link{db_vs_indexes_delete_data}()},
\code{\link{db_vs_indexes_get}()},
\code{\link{db_vs_indexes_list}()},
\code{\link{db_vs_indexes_query}()},
\code{\link{db_vs_indexes_query_next_page}()},
\code{\link{db_vs_indexes_scan}()},
\code{\link{db_vs_indexes_sync}()},
\code{\link{db_vs_indexes_upsert_data}()},
\code{\link{delta_sync_index_spec}()},
\code{\link{embedding_source_column}()},
\code{\link{embedding_vector_column}()}
}
\concept{Vector Search API}
