% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uc-schemas.R
\name{db_uc_schemas_list}
\alias{db_uc_schemas_list}
\title{List Schemas (Unity Catalog)}
\usage{
db_uc_schemas_list(
  catalog,
  max_results = 1000,
  page_token = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{catalog}{Parent catalog for schemas of interest.}

\item{max_results}{Maximum number of schemas to return (default: 1000).}

\item{page_token}{Opaque token used to get the next page of results. Optional.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
List
}
\description{
List Schemas (Unity Catalog)
}
\seealso{
Other Unity Catalog Management: 
\code{\link{db_uc_catalogs_get}()},
\code{\link{db_uc_catalogs_list}()},
\code{\link{db_uc_schemas_get}()}
}
\concept{Unity Catalog Management}
