% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/s3.generics.R
\name{hypothesis}
\alias{hypothesis}
\alias{hypothesis.brmsfit}
\title{Non-linear hypothesis testing}
\usage{
hypothesis(x, hypothesis, ...)
}
\arguments{
\item{x}{An \code{R} object typically of class \code{brmsfit}}

\item{hypothesis}{A character vector specifying one or more non-linear hypothesis concerning fixed effects}

\item{...}{Currently ignored}
}
\value{
Summary statistics of the posterior distributions related to the hypotheses
}
\description{
Perform non-linear hypothesis testing of fixed effects parameters
}
\details{
Currently there are methods for \code{brmsfit} objects.
}
\examples{
\dontrun{
fit_i <- brm(rating ~ treat + period + carry, data = inhaler, family = "cumulative")

hypothesis(fit_i, "treat = period + carry")
hypothesis(fit_i, "exp(treat) - 3 = 0")

## test both of the above hypotheses with the same call
hypothesis(fit_i, c("treat = period + carry", "exp(treat) - 3 = 0"))
}
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

