% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{fixef}
\alias{fixef}
\alias{fixef.brmsfit}
\title{Extract Fixed Effects Estimates}
\usage{
## S3 method for class 'brmsfit'
fixef(x, estimate = "mean", ...)
}
\arguments{
\item{x}{An object of class \code{brmsfit}}

\item{estimate}{A character vector specifying which coefficients (e.g., "mean", "median", "sd", or "quantile") 
should be calculated for the fixed effects.}

\item{...}{Further arguments to be passed to the functions specified in \code{estimate}}
}
\value{
A matrix with one row per fixed effect and one column per calculated estimate.
}
\description{
A generic function to extract the fixed effects from a fitted model object.
}
\examples{
\dontrun{
fixef(brm(time | cens ~ age + sex + disease, data=kidney, family="exponential"),
      estimate = c("mean", "sd"))
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

