% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{stanplot.brmsfit}
\alias{stanplot}
\alias{stanplot.brmsfit}
\title{MCMC Plots Implemented in \pkg{bayesplot}}
\usage{
\method{stanplot}{brmsfit}(object, pars = NA, type = "intervals",
  exact_match = FALSE, ...)

stanplot(object, ...)
}
\arguments{
\item{object}{An \R object typically of class \code{brmsfit}}

\item{pars}{Names of parameters to be plotted, 
as given by a character vector or regular expressions. 
By default, all parameters except for group-level and 
smooth effects are plotted. May be ignored for some plots.}

\item{type}{The type of the plot. 
Supported types are (as names) \code{hist}, \code{dens}, 
\code{hist_by_chain}, \code{dens_overlay}, 
\code{violin}, \code{intervals}, \code{areas}, \code{acf}, 
\code{acf_bar},\code{trace}, \code{trace_highlight}, \code{scatter},
\code{rhat}, \code{rhat_hist}, \code{neff}, \code{neff_hist}
\code{nuts_acceptance}, \code{nuts_divergence},
\code{nuts_stepsize}, \code{nuts_treedepth}, and \code{nuts_energy}. 
For an overview on the various plot types see
\code{\link[bayesplot:MCMC-overview]{MCMC-overview}}.}

\item{exact_match}{Indicates whether parameter names 
should be matched exactly or treated as regular expression. 
Default is \code{FALSE}.}

\item{...}{Additional arguments passed to the plotting functions.
See \code{\link[bayesplot:MCMC-overview]{MCMC-overview}} for
more details.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object 
  that can be further customized using the \pkg{ggplot2} package.
}
\description{
Conveniant way to call MCMC plotting functions 
implemented in the \pkg{bayesplot} package.
}
\details{
Also consider using the \pkg{shinystan} package available via 
  method \code{\link[brms:launch_shiny]{launch_shiny}} 
  in \pkg{brms} for flexible and interactive visual analysis.
}
\examples{
\dontrun{
model <- brm(count ~ log_Age_c + log_Base4_c * Trt_c 
             + (1|patient) + (1|visit),
             data = epilepsy, family = "poisson")
             
# plot posterior intervals
stanplot(model)

# only show population-level effects in the plots
stanplot(model, pars = "^b_")

# show histograms of the posterior distributions
stanplot(model, type = "hist")

# plot some diagnostics of the sampler
stanplot(model, type = "neff")
stanplot(model, type = "rhat")

# plot some diagnostics specific to the NUTS sampler
stanplot(model, type = "nuts_acceptance")
stanplot(model, type = "nuts_divergence")
}

}

