% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_n.R
\name{model_get_n}
\alias{model_get_n}
\alias{model_get_n.default}
\alias{model_get_n.glm}
\alias{model_get_n.glmerMod}
\alias{model_get_n.multinom}
\alias{model_get_n.LORgee}
\alias{model_get_n.coxph}
\alias{model_get_n.survreg}
\alias{model_get_n.model_fit}
\alias{model_get_n.tidycrr}
\title{Get the number of observations}
\usage{
model_get_n(model)

\method{model_get_n}{default}(model)

\method{model_get_n}{glm}(model)

\method{model_get_n}{glmerMod}(model)

\method{model_get_n}{multinom}(model)

\method{model_get_n}{LORgee}(model)

\method{model_get_n}{coxph}(model)

\method{model_get_n}{survreg}(model)

\method{model_get_n}{model_fit}(model)

\method{model_get_n}{tidycrr}(model)
}
\arguments{
\item{model}{a model object}
}
\description{
For binomial and multinomial logistic models, will also return
the number of events.
}
\details{
For Poisson models, will return the number of events and exposure time
(defined with \code{\link[stats:offset]{stats::offset()}}).

For Cox models (\code{\link[survival:coxph]{survival::coxph()}}), will return the number of events and
exposure time.

For competing risk regression models (\code{\link[tidycmprsk:crr]{tidycmprsk::crr()}}), \code{n_event} takes
into account only the event of interest defined by \code{failcode.}

See \code{\link[=tidy_add_n]{tidy_add_n()}} for more details.

The total number of observations (\code{N_obs}), of events (\code{N_event}) and of
exposure time (\code{Exposure}) are stored as attributes of the returned tibble.

This function does not cover \code{lavaan} models (\code{NULL} is returned).
}
\examples{
lm(hp ~ mpg + factor(cyl) + disp:hp, mtcars) \%>\%
  model_get_n()

mod <- glm(
  response ~ stage * grade + trt,
  gtsummary::trial,
  family = binomial,
  contrasts = list(stage = contr.sum, grade = contr.treatment(3, 2), trt = "contr.SAS")
)
mod \%>\% model_get_n()

\dontrun{
mod <- glm(
  Survived ~ Class * Age + Sex, data = Titanic \%>\% as.data.frame(),
  weights = Freq, family = binomial
)
mod \%>\% model_get_n()

d <- dplyr::as_tibble(Titanic) \%>\%
  dplyr::group_by(Class, Sex, Age) \%>\%
  dplyr::summarise(
    n_survived = sum(n * (Survived == "Yes")),
    n_dead = sum(n * (Survived == "No"))
  )
mod <- glm(cbind(n_survived, n_dead) ~ Class * Age + Sex, data = d, family = binomial)
mod \%>\% model_get_n()

mod <- glm(response ~ age + grade * trt, gtsummary::trial, family = poisson)
mod \%>\% model_get_n()

mod <- glm(
  response ~ trt * grade + offset(ttdeath),
  gtsummary::trial,
  family = poisson
)
mod \%>\% model_get_n()

dont
df <- survival::lung \%>\% dplyr::mutate(sex = factor(sex))
mod <- survival::coxph(survival::Surv(time, status) ~ ph.ecog + age + sex, data = df)
mod \%>\% model_get_n()

mod <- lme4::lmer(Reaction ~ Days + (Days | Subject), lme4::sleepstudy)
mod \%>\% model_get_n()

mod <- lme4::glmer(response ~ trt * grade + (1 | stage),
  family = binomial, data = gtsummary::trial
)
mod \%>\% model_get_n()

mod <- lme4::glmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
  family = binomial, data = lme4::cbpp
)
mod \%>\% model_get_n()
}
}
\seealso{
Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_response}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
