% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival-survreg-tidiers.R
\name{tidy.survreg}
\alias{tidy.survreg}
\alias{survreg_tidiers}
\title{Tidy a(n) survreg object}
\usage{
\method{tidy}{survreg}(x, conf.level = 0.95, ...)
}
\arguments{
\item{x}{An \code{survreg} object returned from \code{\link[survival:survreg]{survival::survreg()}}.}

\item{conf.level}{confidence level for CI}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with one row for each term in the
regression. The tibble has columns:

\item{term}{The name of the regression term.}
\item{estimate}{The estimated value of the regression term.}
\item{std.error}{The standard error of the regression term.}
\item{statistic}{The value of a statistic, almost always a T-statistic,
to use in a hypothesis that the regression term is non-zero.}
\item{p.value}{The two-sided p-value associated with the observed
statistic.}
\item{conf.low}{The low end of a confidence interval for the regression
term. Included only if \code{conf.int = TRUE}.}
\item{conf.high}{The high end of a confidence interval for the regression
term. Included only if \code{conf.int = TRUE}.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

library(survival)

sr <- survreg(
  Surv(futime, fustat) ~ ecog.ps + rx,
  ovarian,
  dist = "exponential"
)

td <- tidy(sr)
augment(sr, ovarian)
glance(sr)

# coefficient plot
library(ggplot2)
ggplot(td, aes(estimate, term)) + 
  geom_point() +
  geom_errorbarh(aes(xmin = conf.low, xmax = conf.high), height = 0) +
  geom_vline(xintercept = 0)

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[survival:survreg]{survival::survreg()}}

Other survreg tidiers: 
\code{\link{augment.survreg}()},
\code{\link{glance.survreg}()}

Other survival tidiers: 
\code{\link{augment.coxph}()},
\code{\link{augment.survreg}()},
\code{\link{glance.aareg}()},
\code{\link{glance.cch}()},
\code{\link{glance.coxph}()},
\code{\link{glance.pyears}()},
\code{\link{glance.survdiff}()},
\code{\link{glance.survexp}()},
\code{\link{glance.survfit}()},
\code{\link{glance.survreg}()},
\code{\link{tidy.aareg}()},
\code{\link{tidy.cch}()},
\code{\link{tidy.coxph}()},
\code{\link{tidy.pyears}()},
\code{\link{tidy.survdiff}()},
\code{\link{tidy.survexp}()},
\code{\link{tidy.survfit}()}
}
\concept{survival tidiers}
\concept{survreg tidiers}
