% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-tidiers.R
\name{tidy.ergm}
\alias{tidy.ergm}
\alias{ergm_tidiers}
\title{Tidy a(n) ergm object}
\usage{
\method{tidy}{ergm}(x, conf.int = FALSE, conf.level = 0.95, exponentiate = FALSE, ...)
}
\arguments{
\item{x}{An \code{ergm} object returned from a call to \code{\link[ergm:ergm]{ergm::ergm()}}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{exponentiate}{Logical indicating whether or not to exponentiate the
the coefficient estimates. This is typical for logistic and multinomial
regressions, but a bad idea if there is no log or logit link. Defaults
to \code{FALSE}.}

\item{...}{Additional arguments to pass to \code{\link[ergm:summary]{ergm::summary()}}.
\strong{Cautionary note}: Mispecified arguments may be silently ignored.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row for each coefficient in the
exponential random graph model, with columns:
\item{term}{The term in the model being estimated and tested}
\item{estimate}{The estimated coefficient}
\item{std.error}{The standard error}
\item{mcmc.error}{The MCMC error}
\item{p.value}{The two-sided p-value}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.

The methods should work with any model that conforms to
the \pkg{ergm} class, such as those produced from weighted networks by the
\pkg{ergm.count} package.
}
\examples{

library(ergm)
# Using the same example as the ergm package
# Load the Florentine marriage network data
data(florentine)

# Fit a model where the propensity to form ties between
# families depends on the absolute difference in wealth
gest <- ergm(flomarriage ~ edges + absdiff("wealth"))

# Show terms, coefficient estimates and errors
tidy(gest)

# Show coefficients as odds ratios with a 99\% CI
tidy(gest, exponentiate = TRUE, conf.int = TRUE, conf.level = 0.99)

# Take a look at likelihood measures and other
# control parameters used during MCMC estimation
glance(gest)
glance(gest, deviance = TRUE)
glance(gest, mcmc = TRUE)

}
\references{
Hunter DR, Handcock MS, Butts CT, Goodreau SM, Morris M (2008b).
\pkg{ergm}: A Package to Fit, Simulate and Diagnose Exponential-Family
Models for Networks. \emph{Journal of Statistical Software}, 24(3).
\url{http://www.jstatsoft.org/v24/i03/}.
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[ergm:ergm]{ergm::ergm()}}, \code{\link[ergm:control.ergm]{ergm::control.ergm()}},
\code{\link[ergm:summary]{ergm::summary()}}

Other ergm tidiers: 
\code{\link{glance.ergm}()}
}
\concept{ergm tidiers}
