% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bs_input}
\alias{bs_input}
\title{Create a HTML input tag configured with Bootstrap classes}
\usage{
bs_input(
  type = "text",
  id,
  value = NULL,
  label = NULL,
  placeholder = NULL,
  div_class = NULL,
  input_class = "form-control",
  label_class = "form-label",
  text = NULL,
  text_class = "form-text",
  input_args = list(),
  inline = FALSE
)
}
\arguments{
\item{type}{A string, the type of input to create, passed to the type param of html5::input().}

\item{id}{A string, the id/name for the input, passed to the id and name params of html5::input().}

\item{value}{A string, the value of the input, passed to the value param of html5::input().}

\item{label}{A string, the label to use for the input, passed to html5::label().}

\item{placeholder}{A string, passed to the placeholder param of html5::input().}

\item{div_class}{A string, the class of the div tag surrounding the the label and input tags.}

\item{input_class}{A string, the class of the input tag.}

\item{label_class}{A string, the class of the label tag.}

\item{text}{A string, text or HTML to display with the input and label tags.}

\item{text_class}{A string, the class of the text or HTML to display with the input and label tags.}

\item{input_args}{A named list, names should correspond to a parameter of the html5::input() function and values will be passed to that parameter.}

\item{inline}{TRUE/FALSE, if TRUE, adds a div and classes to display the label and input and text in the same line.}
}
\value{
A string of HTML.
}
\description{
Create a HTML input tag configured with Bootstrap classes
}
\examples{
bs_input(
id = "example1",
label = "Example Text Input",
text = "This is an example input created with the bs_input function."
)
}
