% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_ssm.R
\name{map_ssm}
\alias{map_ssm}
\title{Plot estimated track, behavioural states and observations on a map.}
\usage{
map_ssm(fit, onemap = TRUE)
}
\arguments{
\item{fit}{an output object from \code{fit_ssm}}

\item{onemap}{If TRUE (default) then all estimated tracks are plotted on a single, combined 
map, if FALSE then tracks are plotted on separate maps.}
}
\value{
Observed locations are plotted as '+' symbols and estimated locations as filled
circles. Individual track id's (for DCRW and DCRWS models) are displayed at the top of 
each plot, but only when \code{onemap = FALSE}. The model specified in \code{fit_ssm} is
also displayed at the top. Takes advantage of \code{ggplot2} plotting functions.

Currently, results from the hierarchical models (hDCRW, hDCRWS) can only be plotted on 
a combined map.
}
\description{
Takes a fitted \code{fit_ssm} object and plots the observed (data) and estimated 
locations on a map. For the behavioural models (DCRWS, hDCRWS), the estimated
locations are coloured according to the posterior mean behavioural state estimates.
}
\examples{
\dontrun{
data(ellie)
fit.s <- fitSSM(ellie, model = "DCRWS", tstep = 1, adapt = 2000, samples = 1000, 
              thin = 2, span = 0.1)
map_ssm(fit.s, onemap = TRUE)

hfit.s <- fit_ssm(ellie, model = "hDCRWS", tstep = 1, adapt = 2000, samples = 1000, 
                thin = 2, span = 0.1)
map_ssm(hfit.s)
}
}

