% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed_likes.R
\name{bs_get_likes}
\alias{bs_get_likes}
\title{Retrieve posts liked by an actor}
\usage{
bs_get_likes(
  actor,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{actor}{Character, length 1. name of 1 actor, such as \code{'chriskenny.bsky.social'}}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
a tibble of likes
}
\description{
Retrieve posts liked by an actor
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/getActorLikes.json}{feed/getActorLikes.json (2023-10-01)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-01)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_likes('chriskenny.bsky.social')
\dontshow{\}) # examplesIf}
}
\concept{feed}
