% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_html_fragment.R
\name{render_html_fragment}
\alias{render_html_fragment}
\title{Renders and returns an HTML fragment}
\usage{
render_html_fragment(input, output_format = rmarkdown::html_fragment(), ...)
}
\arguments{
\item{input}{character, path to input file}

\item{output_format}{rmarkdown output format, provided so you can specify arguments}

\item{...}{other arguments passed to
\code{rmarkdown::\link[rmarkdown]{render}}}
}
\value{
\code{htmltools::\link[htmltools]{tag}}
}
\description{
This is a wrapper around the \code{rmarkdown::\link[rmarkdown]{render}}
function. The principal difference is that the function is designed to
return an HTML fragment (rather than writing to a file). This function is
useful to populate the content of a modal window.
}
\details{
This function is being deprecated in favor of
 \code{shiny::\link[shiny]{includeMarkdown}}
}
\examples{
\dontrun{
my_file <- system.file("markdown", "modal.md", package = "bsplus")
render_html_fragment(my_file)
}
}

