% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/60_interface.R
\name{bm}
\alias{bm}
\alias{bm.formula}
\alias{bm.bm}
\alias{blm}
\alias{bslx}
\alias{bsar}
\alias{bsem}
\alias{bsdm}
\alias{bsdem}
\alias{bsv}
\title{Fit a Bayesian model}
\usage{
bm(x, ...)

\method{bm}{formula}(
  x,
  data = NULL,
  n_save = 1000L,
  n_burn = 500L,
  options = set_options(),
  mh = set_mh(),
  verbose = TRUE,
  W,
  X_SLX,
  type = c("lm", "slx", "sar", "sem", "sdm", "sdem", "sv"),
  ...
)

\method{bm}{bm}(x, n_save = 1000L, n_burn = 0L, verbose = TRUE, ...)

blm(...)

bslx(...)

bsar(...)

bsem(...)

bsdm(...)

bsdem(...)

bsv(...)
}
\arguments{
\item{x}{Formula or \code{bm} object to sample with.}

\item{...}{Not used.}

\item{data}{A \code{\link{data.frame}} containing the variables in the model.}

\item{n_save, n_burn}{Integer scalar. Number of draws for the burn-in period and to store for inference.}

\item{options}{Settings for the prior setup. See \code{\link{set_options}}.}

\item{mh}{Settings to tune the Metropolis-Hastings step. See \code{\link{set_mh}}.}

\item{verbose}{Logical scalar. Whether to print status updates.}

\item{W}{Numeric matrix (or function to construct one) with the spatial connectivities.}

\item{X_SLX}{Numeric matrix with explanatory variables that should be lagged spatially.}

\item{type}{Character scalar used to specify the desired model.}
}
\value{
Returns a list with draws from the specified Bayesian model and an object to obtain further samples.
}
\description{
Fit a Bayesian model
}
\examples{
N <- 100L
beta <- 1:5
X <- matrix(rnorm(N * 5), N, 5)
y <- X \%*\% beta + rnorm(N)

bm(y ~ X, n_burn = 100, n_draw = 100)
}
