% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ssm_ulg}
\alias{ssm_ulg}
\title{General univariate linear-Gaussian state space models}
\usage{
ssm_ulg(
  y,
  Z,
  H,
  T,
  R,
  a1,
  P1,
  init_theta = numeric(0),
  D,
  C,
  state_names,
  update_fn = default_update_fn,
  prior_fn = default_prior_fn
)
}
\arguments{
\item{y}{Observations as time series (or vector) of length \eqn{n}.}

\item{Z}{System matrix Z of the observation equation as m x 1 or m x n matrix.}

\item{H}{Vector of standard deviations. Either a scalar or a vector of length n.}

\item{T}{System matrix T of the state equation. Either a m x m matrix or a
m x m x n array.}

\item{R}{Lower triangular matrix R the state equation. Either a m x k matrix or a
m x k x n array.}

\item{a1}{Prior mean for the initial state as a vector of length m.}

\item{P1}{Prior covariance matrix for the initial state as m x m matrix.}

\item{init_theta}{Initial values for the unknown hyperparameters theta.}

\item{D}{Intercept terms for observation equation, given as a length n vector.}

\item{C}{Intercept terms for state equation, given as m x n matrix.}

\item{state_names}{Names for the states.}

\item{update_fn}{Function which returns list of updated model 
components given input vector theta. This function should take only one 
vector argument which is used to create list with elements named as
\code{Z}, \code{H} \code{T}, \code{R}, \code{a1}, \code{P1}, \code{D}, and \code{C},
where each element matches the dimensions of the original model.
If any of these components is missing, it is assumed to be constant wrt. theta.}

\item{prior_fn}{Function which returns log of prior density 
given input vector theta.}
}
\value{
Object of class \code{ssm_ulg}.
}
\description{
Construct an object of class \code{ssm_ulg} by defining the corresponding terms
of the observation and state equation:
}
\details{
\deqn{y_t = X_t beta + D_t + Z_t \alpha_t + H_t \epsilon_t, (\textrm{observation equation})}
\deqn{\alpha_{t+1} = C_t + T_t \alpha_t + R_t \eta_t, (\textrm{transition equation})}

where \eqn{\epsilon_t \sim N(0, 1)}, \eqn{\eta_t \sim N(0, I_k)} and
\eqn{\alpha_1 \sim N(a_1, P_1)} independently of each other, \eqn{X_t} are
 fixed covariates and \eqn{beta} contains the corresponding (known) coefficients.
}
