% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.R
\name{forecast.PosteriorBSVARSV}
\alias{forecast.PosteriorBSVARSV}
\title{Forecasting using Structural Vector Autoregression}
\usage{
\method{forecast}{PosteriorBSVARSV}(
  posterior,
  horizon = 1,
  exogenous_forecast = NULL,
  conditional_forecast = NULL
)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVARSV} obtained by running the \code{estimate} function.}

\item{horizon}{a positive integer, specifying the forecasting horizon.}

\item{exogenous_forecast}{a matrix of dimension \code{horizon x d} containing 
forecasted values of the exogenous variables.}

\item{conditional_forecast}{a \code{horizon x N} matrix with forecasted values 
for selected variables. It should only contain \code{numeric} or \code{NA} 
values. The entries with \code{NA} values correspond to the values that are 
forecasted conditionally on the realisations provided as \code{numeric} values.}
}
\value{
A list of class \code{Forecasts} containing the
draws from the predictive density and for heteroskedastic models the draws 
from the predictive density of structural shocks conditional standard 
deviations and data. The output elements include:

\describe{
 \item{forecasts}{an \code{NxTxS} array with the draws from predictive density}
 \item{forecasts_sigma}{provided only for heteroskedastic models, an \code{NxTxS} array with the draws 
 from the predictive density of structural shocks conditional standard deviations}
 \item{Y}{an \eqn{NxT} matrix with the data on dependent variables}
}
}
\description{
Samples from the joint predictive density of all of the dependent 
variables for models from packages \pkg{bsvars}, \pkg{bsvarSIGNs} or 
\pkg{bvarPANELs} at forecast horizons from 1 to \code{horizon} specified as 
an argument of the function.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar_sv$new(us_fiscal_lsuw, p = 1)

# run the burn-in
burn_in        = estimate(specification, 5)

# estimate the model
posterior      = estimate(burn_in, 10, thin = 2)

# sample from predictive density 1 year ahead
predictive     = forecast(posterior, 2)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_sv$new(p = 1) |>
  estimate(S = 5) |>
  estimate(S = 10, thin = 2) |>  
  forecast(horizon = 2) -> predictive
  
# conditional forecasting 2 quarters ahead conditioning on 
#  provided future values for the Gross Domestic Product 
############################################################
cf        = matrix(NA , 2, 3)
cf[,3]    = tail(us_fiscal_lsuw, 1)[3]   # conditional forecasts equal to the last gdp observation
predictive    = forecast(posterior, 2, conditional_forecast = cf)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_sv$new(p = 1) |>
  estimate(S = 5) |> 
  estimate(S = 10) |> 
  forecast(horizon = 2, conditional_forecast = cf) -> predictive
  
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
