% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer_rectangle.R
\name{buffer_rectangle}
\alias{buffer_rectangle}
\title{A rectangle Function}
\usage{
buffer_rectangle(point, x_length, y_length, degree = 0)
}
\arguments{
\item{point}{Centre point of the buffer, must equal to true in: \code{sf::st_is(point, "POINT")}}

\item{x_length}{Length of the x-side (horizontal side), should be in the unit of projection (numeric)}

\item{y_length}{Length of the y-side (vertical side), should be in the unit of projection (numeric)}

\item{degree}{The angle at which the rectangle is centred (clockwise). Must be between 0 and 360 (numeric)}
}
\value{
An object of class \code{sfc_POLYGON}
}
\description{
Creates a rectangular polygon
}
\examples{
example_point = sf::st_point(c(1,2))
example_point = sf::st_sfc(example_point)
example_point = sf::st_sf(example_point)
buffer_rectangle(example_point, 200, 90, 22) -> rectangular_shaped_buffer
plot(rectangular_shaped_buffer)
}
\references{
Rotation function taken from Edzer Pebesma sf package vignette \url{https://r-spatial.github.io/sf/articles/sf3.html}
}
\keyword{rectangle}
