% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichmentPanel.R
\name{enrichmentPanel}
\alias{enrichmentPanel}
\alias{enrichmentPanelUI}
\alias{enrichmentPanelServer}
\title{Generate the enrichment panel of the shiny app}
\usage{
enrichmentPanelUI(id)

enrichmentPanelServer(id, DEresults, organism, seed = 13)
}
\arguments{
\item{id}{the input slot that will be used to access the value}

\item{DEresults}{differential expression results output from DEpanelServer;
a reactive list with slots 'DEtable' (all genes), 'DEtableSubset' (only DE genes),
'lfcThreshold' and 'pvalThreshold'}

\item{organism}{organism name to be passed on to \code{gprofiler2::gost};
organism names are constructed by concatenating the first letter of the
name and the family name; default is NULL - enrichment is not included
to ensure compatibility with datasets that have non-standard gene names}

\item{seed}{the random seed to be set for the jitter plot, to avoid
seemingly different plots for the same inputs}
}
\value{
The UI and Server components of the shiny module, that can be used
within the UI and Server definitions of a shiny app.
}
\description{
These are the UI and server components of the enrichment panel of the
shiny app. It is generated by including 'Enrichment' in the panels.default argument
of \code{\link{generateShinyApp}}.
}
