% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_stata_data.R
\name{read_stata_data}
\alias{read_stata_data}
\title{Read Stata data file}
\usage{
read_stata_data(file, label = FALSE)
}
\arguments{
\item{file}{The path to the Stata data file.}

\item{label}{Logical indicating whether to use variable labels as column names (default is FALSE).}
}
\value{
A data frame containing the Stata data, with labeled variables converted to factors.
}
\description{
Read Stata data file
}
\examples{
# Read Stata data file without converting variable labels as column names

file_path <- system.file("extdata", "Wages.dta", package = "bulkreadr")

data <- read_stata_data(file = file_path)

data

# Read Stata data file and convert variable labels as column names

data <- read_stata_data(file = file_path, label = TRUE)

data

}
\seealso{
\code{\link[=read_spss_data]{read_spss_data()}} which reads SPSS data file and converts labelled variables into factors.
}
