% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria.R
\name{BIC.varlse}
\alias{BIC.varlse}
\alias{BIC.vharlse}
\alias{BIC.bvarmn}
\alias{BIC.bvarflat}
\alias{BIC.bvharmn}
\title{Bayesian Information Criterion of Multivariate Time Series Model}
\usage{
\method{BIC}{varlse}(object, ...)

\method{BIC}{vharlse}(object, ...)

\method{BIC}{bvarmn}(object, ...)

\method{BIC}{bvarflat}(object, ...)

\method{BIC}{bvharmn}(object, ...)
}
\arguments{
\item{object}{Model fit}

\item{...}{not used}
}
\value{
BIC value.
}
\description{
Compute BIC of VAR(p), VHAR, BVAR(p), and BVHAR
}
\details{
Let \eqn{\tilde{\Sigma}_e} be the MLE
and let \eqn{\hat{\Sigma}_e} be the unbiased estimator (\code{covmat}) for \eqn{\Sigma_e}.
Note that

\deqn{\tilde{\Sigma}_e = \frac{s - k}{n} \hat{\Sigma}_e}

Then

\deqn{BIC(p) = \log \det \Sigma_e + \frac{\log s}{s}(\text{number of freely estimated parameters})}

where the number of freely estimated parameters is \eqn{pm^2}.
}
\references{
Gideon Schwarz. (1978). \emph{Estimating the Dimension of a Model}. Ann. Statist. 6 (2) 461 - 464.

Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.
}
