% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimate_doRedundancyAnalysis.R
\name{doRedundancyAnalysis}
\alias{doRedundancyAnalysis}
\title{Do a redundancy analysis}
\usage{
doRedundancyAnalysis(.object = NULL)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}
}
\value{
A named numeric vector of correlations. If
the weighting approach used to obtain \code{.object} is not \code{"PLS-PM"} or
non of the PLS outer modes was mode B, the function silently returns \code{NA}.
}
\description{
\lifecycle{stable}
}
\details{
Perform a redundancy analysis (RA) as proposed by \insertCite{Hair2016;textual}{cSEM}
with reference to \insertCite{Chin1998;textual}{cSEM}.

RA is confined to PLS-PM, specifically PLS-PM with at least one construct
whose weights are obtained by mode B. In cSEM this is the case if the construct
is modeled as a composite or if argument \code{.PLS_modes} was explicitly set to
mode B for at least one construct.
Hence RA is only conducted if \code{.approach_weights = "PLS-PM"} and if at least
one construct's mode is mode B.

The principal idea of RA is to take two different measures of the
same construct and regress the scores obtained for each measure on each
other. If they are similar they are likely to measure the same "thing"
which is then taken as evidence that both measurement models actually
measure what they are supposed to measure (validity).

There are several issues with the terminology  and the reasoning behind this logic.
RA is therefore only implemented since reviewers are likely to demand
its computation, however, its actual application for validity assessment
is discouraged.

Currently, the function is not applicable to models containing second-order
constructs.
}
\references{
\insertAllCited{}
}
\seealso{
\link{cSEMResults}
}
