% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newXval.R
\name{newXval}
\alias{newXval}
\title{Generation of a new population of parameter sets following the five rules of caRamel}
\usage{
newXval(param, crit, isperf, sp, bounds, repart_gene, blocks, fireworks)
}
\arguments{
\item{param}{: matrix [ Nvec , NPar ] of parameters of the current population}

\item{crit}{: matrix [ Nvec , NObj ] of associated criteria}

\item{isperf}{: vector of Booleans of length NObj, TRUE if maximization of the objective, FALSE otherwise}

\item{sp}{: variance a priori of the parameters}

\item{bounds}{: lower and upper bounds of parameters [ NPar , 2 ]}

\item{repart_gene}{: matrix of length 4 giving the number of games to be generated with each rule: 1 Interpolation in the simplexes of the front, 2 Extrapolation according to the directions of the edges "orthogonal" to the front, 3 Random draws with prescribed variance-covariance matrix, 4 Recombination by functional blocks}

\item{blocks}{: list of integer vectors containing function blocks of parameters}

\item{fireworks}{: boolean, TRUE if one tests a random variation on each parameter and each maximum of O.F.}
}
\value{
xnew : matrix of new vectors [ sum(Repart_Gene) + eventually (nobj+1)*nvar if fireworks , NPar ]

project_crit: assumed position of the new vectors in the criteria space: [ sum(Repart_Gene)+ eventually (nobj+1)*nvar if fireworks , NObj ];
}
\description{
generates a new population of parameter sets following the five rules of caRamel
}
\examples{
# Definition of the parameters
param <- matrix(rexp(100), 100, 1)
crit <- matrix(rexp(200), 100, 2)
isperf <- c(FALSE, FALSE)
bounds <- matrix(data = 1, nrow = 1, ncol = 2)
bounds[, 1] <- -5 * bounds[, 1]
bounds[, 2] <- 10 * bounds[, 2]
sp <- (bounds[, 2] - bounds[, 1]) / (2 * sqrt(3))
repart_gene <- c(5, 5, 5, 5)
fireworks <- TRUE
blocks <- NULL
# Call the function
res <- newXval(param, crit, isperf, sp, bounds, repart_gene, blocks, fireworks)

}
\author{
Fabrice Zaoui
}
