% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache}
\alias{cache}
\title{Cache or Retrieve Computation Results}
\usage{
cache(..., .cachedir = file.path(here("."), ".cache-R"))
}
\arguments{
\item{...}{Named expressions to be cached or retrieved.}

\item{.cachedir}{Directory where cache files are stored.}
}
\description{
Cache or retrieve an evaluated expression. Results are always made available in the current environment.
}
\examples{
tmp = tempdir()

# Takes 1 second to execute
cache(a = {Sys.sleep(2); "Hello World"}, .cachedir = tmp) 

# Executes instantly
cache(a = {Sys.sleep(2); 1}, .cachedir = tmp)

# Result is available in the current environment
print(a)

}
