% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure.trace.R
\name{measure.trace}
\alias{measure.trace}
\title{measure.trace}
\usage{
measure.trace(trace, sr = 44100, hop = 5)
}
\arguments{
\item{trace}{data frame, e.g., the output of the `trace.fund` function.
Should contain columns with time = time in seconds, fund = fundamental
frequency in Hz and missing = logical indicating if the fundamental was
detected (`TRUE`) or interpolated (`FALSE`).}

\item{sr}{sample rate of the wave object used for `trace.fund`.}

\item{hop}{the `hop` parameter used to generate the trace.}
}
\value{
Returns a dataframe with all measurements.
}
\description{
Takes several measurements on a fundamental frequency trace.
}
\examples{
require(callsync)
require(seewave)
require(tuneR)
path_git = 'https://raw.githubusercontent.com'
path_repo = '/simeonqs/callsync/master/tests/testthat/files'
file_1 = '/wave_1.wav'
url_1 = paste0(path_git, path_repo, file_1)
local_file_1 = paste(tempdir(), file_1, sep = '/')
if(!file.exists(local_file_1))
  download.file(url_1, destfile = local_file_1, mode = 'wb',)
wave = readWave(local_file_1)
trace = trace.fund(wave)
result = measure.trace(trace)

}
