% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculatePopChange.R
\name{CalculatePopChange}
\alias{CalculatePopChange}
\title{Population change.}
\usage{
CalculatePopChange(model.out = NULL, variable = NULL, t1 = NULL,
  t2 = NULL, ratio = TRUE)
}
\arguments{
\item{model.out}{output from one of the following functions or a \code{\link{list}} with equivalent structure: \code{\link{SolveIASA}}, \code{\link{SolveSI}},  \code{\link{SolveTC}} or \code{\link{CalculateGlobalSens}}. When the last function is used, its \code{all} argument must be \code{TRUE}.}

\item{variable}{string with the name of the the output variable for which the change are to be calculated (see the variable argument for \code{\link{PlotModels}}.}

\item{t1}{value specifying the first time.}

\item{t2}{value specifying the second time.}

\item{ratio}{logical. When \code{TRUE}, the calculated change is based on poulation size at t2 divided by population size at t1. When \code{FALSE}, the calculated change is based on poulation size at t2 minus population size at t1.}
}
\value{
Value representing the ratio (if \code{ratio} is \code{TRUE}) or the difference (if \code{ratio} is \code{FALSE}) between population size at time t2 and t1. If only one time is specified, the value is the population size at that time.
}
\description{
Calculate the change in population size between two times. When only one time is specified, the population size at that time is returned.
}
\examples{
## IASA model

## Parameters and intial conditions.
data(dogs)
dogs_iasa <- GetDataIASA(dogs,
                         destination.label = "Pinhais",
                         total.estimate = 50444)

# Solve for point estimates.
solve_iasa_pt <- SolveIASA(pars = dogs_iasa$pars,
                          init = dogs_iasa$init,
                          time = 0:15,
                          alpha.owned = TRUE,
                          method = 'rk4')

# Calculate the population change (ratio) between times 0 and 15.
CalculatePopChange(solve_iasa_pt, variable = 'N1', t2 = 15, t1 = 0)

# Calculate the population change (difference) between times 0 and 15.
CalculatePopChange(solve_iasa_pt, variable = 'N1', t2 = 15,
                   t1 = 0, ratio = FALSE)

# Calculate the population zises at time 15.
CalculatePopChange(solve_iasa_pt, variable = 'N1', t2 = 15)

}
\references{
Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.

\url{http://oswaldosantos.github.io/capm}
}
