% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical_theatre_data.R
\name{clinical_theatre_data}
\alias{clinical_theatre_data}
\title{Clinical Emissions: Data Frame and Plot}
\usage{
clinical_theatre_data(
  data,
  time,
  date_format = c("\%d/\%m/\%Y"),
  name,
  wet_clinical_waste = 0,
  wet_clinical_waste_unit = c("tonnes", "kg"),
  desflurane = 0,
  sevoflurane = 0,
  isoflurane = 0,
  methoxyflurane = 0,
  N2O = 0,
  propofol = 0,
  water_supply = 0,
  water_trt = TRUE,
  water_unit = c("cubic metres", "million litres"),
  electricity_kWh = 0,
  electricity_TD = TRUE,
  electricity_WTT = TRUE,
  heat_kWh = 0,
  heat_TD = TRUE,
  heat_WTT = TRUE,
  glass = 0,
  board = 0,
  mixed = 0,
  paper = 0,
  average = 0,
  average_film = 0,
  average_rigid = 0,
  HDPE = 0,
  LDPE = 0,
  LLDPE = 0,
  PET = 0,
  PP = 0,
  PS = 0,
  PVC = 0,
  glass_WD = 0,
  glass_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  board_WD = 0,
  mixed_WD = 0,
  paper_WD = 0,
  paper_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill"),
  average_WD = 0,
  average_film_WD = 0,
  average_rigid_WD = 0,
  HDPE_WD = 0,
  LDPE_WD = 0,
  LLDPE_WD = 0,
  PET_WD = 0,
  PP_WD = 0,
  PS_WD = 0,
  PVC_WD = 0,
  plastic_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  fridges = 0,
  freezers = 0,
  electric_waste_disposal = c("Landfill", "Open-loop"),
  glass_units = c("kg", "tonnes"),
  paper_units = c("kg", "tonnes"),
  plastic_units = c("kg", "tonnes"),
  electrical_units = c("kg", "tonnes"),
  include_cpi = FALSE,
  jurisdiction = NULL,
  year = NULL,
  period = 0,
  manual_price = NULL,
  gti_by = c("default", "month", "year"),
  overall_by = c("default", "month", "year"),
  single_sheet = FALSE
)
}
\arguments{
\item{data}{Data frame containing all data to be used in the emissions calculation}

\item{time}{Variable in \code{data} that corresponds to the time.}

\item{date_format}{The date format for the time variable (optional, default: c("\%d/\%m/\%Y")).}

\item{name}{Variable in \code{data} that corresponds to the theatre name.}

\item{wet_clinical_waste}{Amount of (wet) clinical waste that is usually incinerated.}

\item{wet_clinical_waste_unit}{Unit for \code{wet_clinical_waste} variable. Options are \code{"tonnes"} or \code{"kg"}.}

\item{desflurane}{Amount of desflurane used in KG (default: 0).}

\item{sevoflurane}{Amount of sevoflurane used in KG (default: 0).}

\item{isoflurane}{Amount of isoflurane used in KG (default: 0).}

\item{methoxyflurane}{Amount of methoxyflurane used in KG (default: 0).}

\item{N2O}{Amount of nitrous oxide (N2O) used in KG (default: 0).}

\item{propofol}{Amount of propofol used in KG (default: 0).}

\item{water_supply}{Amount of water used in the building.}

\item{water_trt}{logical. Default \code{TRUE}. Whether to include emissions associated with water treatment for used water.}

\item{water_unit}{Unit for \code{water_supply} variable. Options are \code{"cubic metres"} or \code{"million litres"}.}

\item{electricity_kWh}{Electricity used in kWh.}

\item{electricity_TD}{logical. Default \code{TRUE}. Whether to include emissions associated with grid losses.}

\item{electricity_WTT}{logical. Default \code{TRUE}. Whether to include emissions associated with extracting, refining, and transporting fuels.}

\item{heat_kWh}{heat and steam used in kWh.}

\item{heat_TD}{logical. Default \code{TRUE}. Whether to include emissions associated with grid losses.}

\item{heat_WTT}{logical. Default \code{TRUE}. Whether to include emissions associated with extracting, refining, and transporting fuels.}

\item{glass}{Numeric value representing the amount of glass. Default is \code{0}.}

\item{board}{Numeric value indicating the weight of paperboard. Default is \code{0}.}

\item{mixed}{Numeric value indicating the weight of mixed paper. Default is \code{0}.}

\item{paper}{Numeric value indicating the weight of paper. Default is \code{0}.}

\item{average}{Numeric value indicating the weight of average plastic. Default is \code{0}.}

\item{average_film}{Numeric value indicating the weight of average film plastic. Default is \code{0}.}

\item{average_rigid}{Numeric value indicating the weight of average rigid plastic. Default is \code{0}.}

\item{HDPE}{Numeric value indicating the weight of HDPE plastic. Default is \code{0}.}

\item{LDPE}{Numeric value indicating the weight of LDPE plastic. Default is \code{0}.}

\item{LLDPE}{Numeric value indicating the weight of LLDPE plastic. Default is \code{0}.}

\item{PET}{Numeric value indicating the weight of PET plastic. Default is \code{0}.}

\item{PP}{Numeric value indicating the weight of PP plastic. Default is \code{0}.}

\item{PS}{Numeric value indicating the weight of PS plastic. Default is \code{0}.}

\item{PVC}{Numeric value indicating the weight of PVC plastic. Default is \code{0}.}

\item{glass_WD}{Numeric value representing the amount of glass waste with disposal. Default is \code{0}.}

\item{glass_waste_disposal}{Character vector specifying the waste disposal method to use for metal for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Landfill"}, \code{"Open-loop"}. Default is "Closed-loop". See \code{details} for more information.}

\item{board_WD}{Numeric value indicating the weight of paperboard disposed of using waste disposal methods. Default is \code{0}.}

\item{mixed_WD}{Numeric value indicating the weight of mixed paper disposed of using waste disposal methods. Default is \code{0}.}

\item{paper_WD}{Numeric value indicating the weight of paper disposed of using waste disposal methods. Default is \code{0}.}

\item{paper_waste_disposal}{Character vector specifying the waste disposal method for paper to use for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Composting"}, \code{"Landfill"}. Default is \code{"Closed-loop"}. See \code{details} for more information.}

\item{average_WD}{Numeric value indicating the weight of average plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{average_film_WD}{Numeric value indicating the weight of average film plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{average_rigid_WD}{Numeric value indicating the weight of average rigid plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{HDPE_WD}{Numeric value indicating the weight of HDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{LDPE_WD}{Numeric value indicating the weight of LDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{LLDPE_WD}{Numeric value indicating the weight of LLDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PET_WD}{Numeric value indicating the weight of PET plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PP_WD}{Numeric value indicating the weight of PP plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PS_WD}{Numeric value indicating the weight of PS plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PVC_WD}{Numeric value indicating the weight of PVC plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{plastic_waste_disposal}{Character vector specifying the waste disposal method for plastic to use for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Landfill"}, \code{"Open-loop"}. Default is \code{"Closed-loop"}. See \code{details} for more information.}

\item{fridges}{Numeric value indicating the weight of fridges. Default is \code{0}.}

\item{freezers}{Numeric value indicating the weight of freezers. Default is \code{0}.}

\item{electric_waste_disposal}{Character vector specifying the waste disposal method for electrical items to use for calculating emissions. Possible values: \code{"Landfill"}, \code{"Open-loop"}. Default is \code{"Landfill"}. See \code{details} for more information.}

\item{glass_units}{Character vector specifying the units of the emissions related to glass. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}

\item{paper_units}{Character vector specifying the units of the emissions related to paper. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}

\item{plastic_units}{Character vector specifying the units of the emissions related to plastic materials. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}

\item{electrical_units}{Character vector specifying the units of the emissions related to electrical materials. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}

\item{include_cpi}{Logical variable specifying whether to calculate carbon price credit as well as emissions.}

\item{jurisdiction}{A character string specifying the jurisdiction for which the carbon price credit should be calculated. Available jurisdictions can be found by \code{check_CPI()}.}

\item{year}{An optional numeric value specifying the year for which the carbon price credit should be calculated.
If \code{NULL}, the most recent year available in the CPI data will be used.}

\item{period}{An optional numeric value specifying the period within the specified year for which the carbon price credit should be calculated.
If \code{1}, the function will use the first period if it is available; if \code{2}, the function will use the second period if it is available. If \code{0}, the function will calculate the mean between the first and second period.}

\item{manual_price}{An option to manually input a carbon price index to override the value in the World Bank Data.}

\item{gti_by}{The grouping type for calculating the GTI ("default", "month", "year").}

\item{overall_by}{The grouping type for the total output plot ("default", "month", "year"). This is a plot of the emissions if \code{include_cpi = FALSE}, otherwise is the CPI value.}

\item{single_sheet}{Options are \code{NULL}, \code{TRUE} or \code{FALSE}. This is whether to give the summaries in a single sheet display, or as a list containing the table and \code{ggplot2} objects.
If \code{NULL} then no graphical output is given.}
}
\value{
Returns list containing two objects. A table containing CO2e emissions for each row of data (and carbon price index in USD if \code{include_cpi} is \code{TRUE}), and a \code{ggplot2} object plotting the CO2e emissions. The second object is a single sheet containing summaries if \code{single_sheet = TRUE}.
}
\description{
Get the clinical theatre emissions after a data frame is inputted into the function.
}
\examples{
\donttest{
# Example with dummy data
df <- data.frame(time = c("10/04/2000", "10/04/2000", "11/04/2000",
                          "11/04/2000", "12/04/2000", "12/04/2000"),
                 theatre = rep(c("A", "B"), times = 3),
                 clinical_waste = c(80, 90, 80, 100, 120, 110),
                 electricity_kwh = c(100, 110, 90, 100, 100, 110),
                 general_waste = c(65, 55, 70, 50, 60, 30))

clinical_theatre_data(df, time = time, name = theatre,
                 wet_clinical_waste = clinical_waste,
                 wet_clinical_waste_unit = "kg",
                 desflurane = 10,
                 average = general_waste,
                 plastic_units = "kg",
                 electricity_kWh = electricity_kwh,
                 include_cpi = TRUE,
                 jurisdiction = "Australia",
                 year = 2023,
                 single_sheet = FALSE)
}
}
