% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_twogrid_overlap}
\alias{make_twogrid_overlap}
\title{Generate Two Overlapping Grid Clusters in High Dimensions}
\usage{
make_twogrid_overlap(n = c(500, 500))
}
\arguments{
\item{n}{A numeric vector of length 2 specifying the number of points
in each grid cluster.}
}
\value{
A tibble with \code{n[1] + n[2]} rows and 5 columns:
  \itemize{
    \item \code{x1,x2, x3, x4} — coordinates of the generated points.
    \item \code{cluster} — cluster membership label.
  }
}
\description{
This function generates a dataset consisting of two overlapping
grid-like clusters in a 2D space, with optional noise dimensions
added to reach higher-dimensional spaces. The overlap is controlled
by scaling factors for the grids.
}
\examples{
# Generate two overlapping grid clusters in 4-D
df <- make_twogrid_overlap()

}
