% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_models.R
\name{setup_risk_events}
\alias{setup_risk_events}
\title{setup_risk_events}
\usage{
setup_risk_events(time_span, avg_event_strength = 1, area_risks)
}
\arguments{
\item{time_span}{Simulation time span to be covered (integer)}

\item{avg_event_strength}{Number which indicates the average strength of a
damage event in the simulation. Default is 1 which means that the survival
probabilities as defined in the silvicultural concept of interest are
applied exactly as they are. A value of 2 would mean that one damage event
would have the same effect as would two subsequent events with normal
strength. A value of 0 would trigger no damage events at all.}

\item{area_risks}{Vector of subphase-wise baseline damage risks, contained in
the list made with \code{\link{setup_parms}} under the name \code{risk}.}
}
\value{
A matrix where each row is a point in simulation time, and each
column represents a subphase of the silvicultural concept of interest (in
increasing order). Each matrix element describes the relative area loss
that will happen at a given time to a given subphase.
}
\description{
Low-level function for setting up a risk matrix for a simulation run.
Available for users who want to build simulation runs out of single elements.
Regular users are recommended to use the function
\code{\link{simulate_single_concept}} for running a simulation with one
single command (where this function is internally used).
}
\details{
The function uses exponentially distributed random numbers (with expectation
= 1) for simulating the strenghth of damaging events. Such kind of
distribution where small events are much more frequent than strong ones is a
realistic assumption for forest damages. Such a random number is drawn for
each simulation point in time. The actual damage strength (i.e. relative area
loss) for a given subphase is then calculated as follows:\cr
\code{rel_area_loss = 1 - ((1 - x) ^ avg_event_strength) ^ event_strength},
\cr
where\cr
\itemize{
\item{x: The baseline area loss risk of a given stand development
subphase as resulting from the silvicultural concept definition of
interest}
\item{avg_event_strength: The user defined overall average event
strenghth}
\item{event_strength: Exponentially distributed random number with
expectation 1, indicating the damage event strength in a given year}
}
}
\examples{
  parms <- setup_parms(pine_no_thinning_and_clearcut_1)
  setup_risk_events(time_span = 200,
                    avg_event_strength = 3,
                    area_risks = parms$risk)

}
