\name{caribou-package}
\alias{caribou-package}
\alias{caribou}
\docType{package}
\title{ Estimation of caribou abundance based on large scale aggregations monitored by radio telemetry }
\description{
This is a package for estimating the population size of migratory caribou herds 
based on large scale aggregations monitored by radio telemetry. It implements 
the methodology found in the article by Rivest et al. (1998) about caribou 
abundance estimation. It also includes a function based on the Lincoln-Petersen 
Index as applied to radio telemetry data by White and Garrott (1990).
}
\details{
\tabular{ll}{
Package: \tab caribou\cr
Type: \tab Package\cr
Version: \tab 1.1\cr
Date: \tab 2012-06-11\cr
License: \tab GPL-2\cr
}
CONTEXT:\cr

Migratory caribou forms aggregations at different seasons in their yearly life cycle, 
namely in the spring and fall migration, and also in summer following insect harassment. 
Postcalving aggregations that happened in July under warm and calm conditions 
are the most impressive and they are well known for long time by caribou biologists
and by indigenous people. The Inuit that lived also in the tundra with caribou described 
this spectacular animal behavior as the moving mountains.\cr    

Rivest et al. (1998) proposed a new method for estimating caribou herd size based on 
photo-census of large scale aggregations. This method can also be used in other time 
of the year for caribou or for other wildlife species that live in open habitat like tundra. 
Here we provided some dataset examples for postcalving census done in Quebec and 
elsewhere in North America.\cr 

If you are using this tool to estimate wildlife abundance, please let us know 
and quote this paper:\cr
Rivest, L.-P., Couturier, S. and Crepeau, H. (1998). Statistical Methods for estimating caribou abundance 
using postcalving aggregations detected by radio telemetry. \emph{Biometrics}, \bold{54}(3), 865-876.
}
\author{ Helene Crepeau \email{Helene.Crepeau@mat.ulaval.ca} and\cr
Louis-Paul Rivest \email{Louis-Paul.Rivest@mat.ulaval.ca} and\cr
Serge Couturier \email{tuttu@videotron.ca} and\cr 
Sophie Baillargeon \email{Sophie.Baillargeon@mat.ulaval.ca} }
\references{
Rivest, L.-P., Couturier, S. and Crepeau, H. (1998). Statistical Methods for estimating caribou abundance 
using postcalving aggregations detected by radio telemetry. \emph{Biometrics}, \bold{54}(3), 865-876.

White, G.C. and Garrott, R.A. (1990). \emph{Analysis of wildlife radio-tracking data}. San Diego: 
Academic Press.
}
\keyword{ package }
