% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowgini.R
\name{flowgini}
\alias{flowgini}
\title{Analysis of flow concentration (Gini coefficient)}
\usage{
flowgini(tab, origin, dest, valflow, format, fdc, code, lorenz.plot)
}
\arguments{
\item{tab}{dataset is a matrice or long format}

\item{origin}{origin place to be used with the long format}

\item{dest}{destination place to be used with the list format}

\item{valflow}{to be used with the list format}

\item{format}{is a variable that identify the data : matrice or long format}

\item{fdc}{is the map background file, ie. a shapefile.}

\item{code}{is the map background IDs code}

\item{lorenz.plot}{allows to plot the Lorenz curve associate to the gini coefficient}
}
\value{
plot Lorenz curve for the cumulated flow and links : flowgini(...,gini.plot = TRUE),warning : the function must be not assign a variable

value of the Gini's coefficent and the table : table<-flowgini(...,missing(gini.plot) or gini.plot = FALSE )
}
\description{
Calculates Gini coefficient, plot Lorenz curve and
threshold the matrice according to a global concentration criterion for mapping flow intensity or flow density).\cr
To be use before \link{flowanalysis}
}
\details{
flowgini(...,lorenz.plot = TRUE) for ploting Lorenz curve from cumulated flows and links.
}
\examples{
library(cartograflow)
data(flowdata)
bkg<- system.file("shape/MGP_TER.shp", package="cartograflow",
                  lib.loc = NULL, mustWork = TRUE)
#Computes Gini's coefficent
tab_gini<-flowgini(flows,format="L",origin="i",dest="j",valflow="Fij",
          bkg,code="EPT_NUM",lorenz.plot = FALSE)
#Plot Lorenz curve
flowgini(tab_gini,format="L",origin="i",dest="j",valflow="ydata",
          bkg,code="EPT_NUM",lorenz.plot = TRUE)
#See \\link{flowanalysis} for viewing the tab_gini table
}
\references{
Bahoken Françoise, 2016,« La cartographie d’une sélection globale de flux, entre ‘significativité’ et ‘densité’ »,
Netcom Online, 30-3/4 | 2016, Online since 23 March 2017, connection on 05 May 2019. URL : http://journals.openedition.org/netcom/2565 ;
DOI : 10.4000/netcom.2565. \cr
Grasland Claude, 2014, "Flows analysis carto", unpublished R functions.
}
