% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve_feature_type}
\alias{resolve_feature_type}
\title{Guess the feature type if it was missing}
\usage{
resolve_feature_type(feature_type, feature_names)
}
\arguments{
\item{feature_type}{Type of map feature. See \code{\link[=feature_types]{feature_types()}} for a list of
registered types. If \code{NA}, the type is guessed based on the values in
\code{feature_names}.}

\item{feature_names}{Character vector of feature names in the data. This can
be a subset of the values.}
}
\value{
The resolved feature type as a scalar character.
}
\description{
If \code{feature_type} is provided, this simply checks that the type has been
registered. If it is \code{NA}, however, an attempt it made to guess the
appropriate choice. This is done by comparing the example values provided
as \code{feature_names} with the names of all registered map datasets. If there
is an unambiguous match, that will be filled in.
}
\details{
Note that this requires that any lazily-loaded datasets are loaded, so there
is a penalty to pay for the convenience.
}
\examples{
resolve_feature_type("sf.nc")
resolve_feature_type(NA, feature_names = c("ANSON", "Stanly"))
}
