% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typoLayer.R
\name{typoLayer}
\alias{typoLayer}
\title{Typology Layer}
\usage{
typoLayer(x, spdf, df, spdfid = NULL, dfid = NULL, var, col = NULL,
  border = "grey20", lwd = 1, colNA = "white",
  legend.pos = "bottomleft", legend.title.txt = var,
  legend.title.cex = 0.8, legend.values.cex = 0.6,
  legend.values.order = NULL, legend.nodata = "no data",
  legend.frame = FALSE, add = FALSE)
}
\arguments{
\item{x}{an sf object, a simple feature collection. If x is used then spdf, df, spdfid and dfid are not.}

\item{spdf}{a SpatialPolygonsDataFrame.}

\item{df}{a data frame that contains the values to plot. If df is missing 
spdf@data is used instead.}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{dfid}{identifier field in df, default to the first column 
of df. (optional)}

\item{var}{name of the field in df to plot.}

\item{col}{a vector of colors.}

\item{border}{color of the polygons borders.}

\item{lwd}{borders width.}

\item{colNA}{no data color.}

\item{legend.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)). If 
legend.pos is "n" then the legend is not plotted.}

\item{legend.title.txt}{title of the legend.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.values.order}{values order in the legend, a character vector 
that matches var modalities. Colors will be affected following this order.}

\item{legend.nodata}{no data label.}

\item{legend.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\description{
Plot a typology layer.
}
\examples{
data(nuts2006)
## Example 1
nuts0.df$typo <- c(rep("A",10),rep("B",10),rep("C",10),rep("D",4))
typoLayer(spdf = nuts0.spdf, df = nuts0.df, var = "typo")


## Example 2
mtq <- st_read(system.file("shape/martinique.shp", package="cartography"))
typoLayer(x = mtq, var="STATUT",  
          col = c("aquamarine4", "yellow3","wheat"),
          legend.values.order = c("Préfecture de région",
                                  "Sous-préfecture", 
                                  "Commune simple"),
          legend.pos = "topright",
          legend.title.txt = "Status")
layoutLayer(title = "Commune Status",
            author = "UMS RIATE, 2017",
            sources = "IGN, 2016",
            scale = NULL)
}
\seealso{
\link{propSymbolsTypoLayer}, \link{typoLayer}, \link{legendTypo}
}
