% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brktrials3.R
\name{brktrials3}
\alias{brktrials3}
\title{\code{brktrials3} produces \code{t-x} trajectories for lead and following vehicles at a bottleneck}
\usage{
brktrials3(nveh, umn, usd, tstart, tend, xstart, step, type, leff, xfunnel)
}
\arguments{
\item{nveh}{number of vehicles entering the bottleneck, a number}

\item{umn}{start speed (mph) for vehicle in lane 1, a number}

\item{usd}{speed volatility (mph) for \code{umn}, a number}

\item{tstart}{start time, (seconds), a number}

\item{tend}{end time, (seconds), a number}

\item{xstart}{start location, (feet), a number}

\item{step}{size in seconds, a number}

\item{type}{TRUE to create plots or FALSE otherwise, a logical}

\item{leff}{vehicle length in feet, a number}

\item{xfunnel}{upstream location of bottleneck taper, a number}
}
\value{
\code{brktrials3} returns  \code{t-x} trajectories of \code{nveh} vehicles at a bottleneck.
}
\description{
\code{brktrials3} produces \code{t-x} trajectories for lead and following vehicles at a bottleneck
}
\examples{
brktrials3(4, 68.4, 4.4, 0, 30, -700, 0.25, FALSE, 14, -500)
}
