% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DevFac.R
\docType{methods}
\name{setDevFac}
\alias{setDevFac}
\alias{setDevFac,DevFac-method}
\alias{setDevFac,ANY-method}
\title{Set up an IBNER loss development schedule.}
\usage{
setDevFac(object, ...)

\S4method{setDevFac}{DevFac}(object)
}
\arguments{
\item{object}{DevFac Object}

\item{...}{Additional function arguments}
}
\description{
\code{setDevFac} sets a loss development schedule, from either a predictive model or a year-to-year factor vector.
}
\examples{
xIBNERFactor <- new("DevFac", FacID = "IF1", FacModel = FALSE, meanList = c(1.26,1.1,1.05,1.02,1),
volList = rep(0.02,5))
xIBNERFactor<-setDevFac(xIBNERFactor)
xIBNERFactor

xIBNERFactor <- new("DevFac")
setID(xIBNERFactor)<-"IF1"
setFacModel(xIBNERFactor)<-TRUE
setFun(xIBNERFactor)<-"identity"
setXname(xIBNERFactor)<- c("x1","x2","x3")
setParas(xIBNERFactor)<-c(0.6,-0.2,0.01,-0.3,0.02,0.03,0.01,0.02)
xIBNERFactor<-setDevFac(xIBNERFactor)
xIBNERFactor
}
