% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFit.R
\name{PlotFit}
\alias{PlotFit}
\title{Plot the fitted network models}
\usage{
PlotFit(list, Matrix_to_plot, OrderBy = "Default", addDots = TRUE,
  title = NULL, Combine = "+", RemoveTP = FALSE, GuidesOff = TRUE)
}
\arguments{
\item{list}{A list-format network (output from xxx)}

\item{Matrix_to_plot}{Which matrix / matrices to plot. One or more of 'C_def','C', 'M', 'B', 'SBM'}

\item{OrderBy}{How to order the plot. One of 'Default','Degree','Manual', 'LatentTrait','SBM', 'AsPerMatrix'}

\item{addDots}{Should dots be added to show observations. TRUE, FALSE or 'Size', to plot by interaction strength}

\item{title}{A title. By default it will use the value of Matrix_to_plot}

\item{Combine}{How should multiple matrices be combined. Either '+' which averages them (default), or '*' which multiples}

\item{RemoveTP}{Should true positives be set to NA in order to highlight differences in predictions. Default is FALSE}

\item{GuidesOff}{Should the legends be switched off. Defaults to TRUE}
}
\value{
A ggplot object, which by default will print to the device, but can be added to make further tweaks
}
\description{
Takes the output from other functions (including \code{PredictLinks()}) to visualise the fit to the
 data and predictions of missing links.
}
\details{
See the vignette for a more through description and examples.
}
\examples{

\dontrun{
data(Safariland, package = 'bipartite')
Predictions<- PredictLinks(Safariland)
PlotFit(Predictions, Matrix_to_plot = 'SBM')
}

\dontshow{
data(Safariland, package ='bipartite')
tmp<- PredictLinks(Safariland[,1:10], RepeatModels = 1) # Smaller to finish in time for CRAN tests
PlotFit(tmp, Matrix_to_plot = 'SBM')
}


}
