% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjusted.R
\name{sc_sparse2}
\alias{sc_sparse2}
\alias{sc_sparse2.default}
\alias{sc_sparse2.scree}
\alias{sc_sparse2.list}
\title{Compute  adjusted sparse measure using the alpha hull}
\usage{
sc_sparse2(x, y)

\method{sc_sparse2}{default}(x, y)

\method{sc_sparse2}{scree}(x, y = NULL)

\method{sc_sparse2}{list}(x, y = NULL)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values}
}
\value{
A "numeric" object that gives the plot's sparse2 score.
}
\description{
Compute  adjusted sparse measure using the alpha hull
}
\examples{
  require(ggplot2)
  require(tidyr)
  require(dplyr)
  data(anscombe_tidy)
  ggplot(anscombe_tidy, aes(x=x, y=y)) +
    geom_point() +
    facet_wrap(~set, ncol=2, scales = "free")
  sc_sparse2(anscombe$x1, anscombe$y1)

}
