% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{expectedKL}
\alias{expectedKL}
\title{Expected Kullback-Leibler Information}
\usage{
expectedKL(catObj, item)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{item}{An integer indicating the index of the question item}
}
\value{
The function \code{expectedKL} returns a numeric indicating the
expected Kullback-Leibler information
 for the specified item, given the current answer profile and ability parameter estimate.
}
\description{
Calculates the expected Kullback-Leibler information for an individual question item.
}
\details{
The function \code{expectedKL} calculates the expected value of the Kullback-Leibler information
for a specified item where the bounds of integration are \eqn{\hat{\theta} \pm \delta},
 where \eqn{\delta} is qnorm(\eqn{z}) times the square root of the Fisher test information and
 \eqn{z} is specified in the \code{z} slot of the \code{Cat} object.  See \strong{Note} for more information on integration.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.

This function uses adaptive quadrature methods from the GNU Scientific
 Library (GSL) to approximate single-dimensional
 integrals with high accuracy.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## Estimate KL for different unasked items
expectedKL(ltm_cat, item = 10)
expectedKL(ltm_cat, item = 20)
expectedKL(ltm_cat, item = 30)


}
\seealso{
\code{\link{likelihoodKL}}, \code{\link{posteriorKL}}, \code{\link{selectItem}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
