% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalClusterQuality.R
\encoding{UTF-8}
\name{ARI}
\alias{ARI}
\title{Adjusted Rand index}
\usage{
ARI(x, y, signif = FALSE, n = 1000)
}
\arguments{
\item{x}{vector of cluster memberships (integers)}

\item{y}{vector of cluster memberships (integers)}

\item{signif}{conduct significance test; default is \code{FALSE}}

\item{n}{number of replicates in Monte Carlo significance test}
}
\value{
ari adjusted Rand index

nari normalized adjusted Rand index

sim.mean average value of null distribution (should be closed to zero)

sim.var variance of null distribution

pvalue P value of observed ARI (or NARI) value
}
\description{
Calculate the adjusted Rand index between two sets of cluster memberships.
}
\examples{
x <- sample(1:3, 30, replace = TRUE)
y <- sample(1:3, 30, replace = TRUE)

ARI(x, y, signif = FALSE)
}
\references{
Hubert, L., & Arabie, P. (1985). Comparing partitions. 
\emph{Journal of Classification}, 2, 193–218.
\doi{10.1007/BF01908075}.

Qannari, E.M., Courcoux, P., & Faye, P. (2014). 
Significance test of the adjusted Rand index. Application to the free sorting 
task. \emph{Food Quality and Preference}, 32, 93-97. 
\doi{10.1016/j.foodqual.2013.05.005}.
}
