% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCaseAttribute.R
\name{getCaseAttribute}
\alias{getCaseAttribute}
\title{Get attributes related to a case}
\usage{
getCaseAttribute(attribute, case)
}
\arguments{
\item{attribute}{character scalar. Names the CCM object to
obtain related information about a case. One of the
currently supported objects:
\enumerate{
\item \code{exposures}: Exposures
\item \code{interventions}: Interventions
\item \code{labResults}: Lab Results
\item \code{outbreaks}: Outbreaks
\item \code{riskFactor}: Risk Factors
\item \code{symptoms}: Symptoms
}}

\item{case}{character scalar or vector. Names the CCM Case Id
to use when obtaining information.}
}
\value{
a \code{data.frame} of information related to a case.
}
\description{
\code{getCaseAttribute()} specifies the object used to
get related information about a case. This function
wraps \code{getAttribute()} to allow iteration over multiple
cases. See \code{getAttribute()}
}
\seealso{
\code{\link[=getAttribute]{getAttribute()}} for information on how the CCM
query is executed. \code{\link[=getCases]{getCases()}} for obtaining Case Id's
required for this function.
}
