% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExposures.R
\name{getExposures}
\alias{getExposures}
\title{Execute a SOQL query against the Exposure object}
\usage{
getExposures(
  type = NULL,
  from = "1990-01-01",
  to = as.character(Sys.Date()),
  columns = "Id",
  healthUnit = NULL
)
}
\arguments{
\item{type}{Character vector or scalar. Names the exposure type used
to filter the query. Defaults to all exposure types. One or more of:
\enumerate{
\item \code{Community}
\item \verb{Congregate Living}
\item \code{Household}
\item \code{Institutional}
\item \code{Travel}
}}

\item{from}{Character scalar. Identifies the start of the date range
to include in the query. Defaults to the origin date of CCM.}

\item{to}{Character scalar. Identifies the end of the date range
to include in the query. Defaults to \code{Sys.Date()} (i.e. today's date).}

\item{columns}{Character scalar or character vector. Names the columns to
return from the exposure object. Defaults to \code{Id}.}

\item{healthUnit}{Character vector or scalar. Names the Public Health Unit
used to filter the query. \code{getExposures()} filters on Exposure PHU. Defaults
to NULL (i.e. no health unit filter).}
}
\value{
If the query succeeds, a \code{tibble} containing \code{columns}.
}
\description{
\code{getExposures()} returns a user-defined data from the CCM Exposure object.
The Exposure object maps to Exposures on the client-side.
}
\examples{
\dontrun{
Get all community exposures for Durham
exposures <- getExposures(
  type = 'Community',
  healthUnit = 'Durham Region Health Department'
)
Specify the data to return.
exposures <- getExposures(
  columns = c("Id", "Name", "CCM_Exposure_Setting__c")
)
Limit the data to a specific time period.
exposures <- getExposures(
  from = "2020-12-12",
  to = "2020-12-17"
)
}
}
